import re
from typing import Tuple, List, Iterable
from functools import partial


def has(input_seq: Tuple[str], tar_seq: Tuple[str]) -> int:
    cnt = 0
    for i, it in enumerate(input_seq):
        if it == tar_seq[0]:
            if i + len(tar_seq) <= len(input_seq) and input_seq[i:i + len(tar_seq)] == tar_seq:
                cnt += 1
    return cnt


def followed(input_seq: Tuple[str], tar_seq: Tuple[str], flw_seq: Tuple[str]) -> bool:
    for i, it in enumerate(input_seq):
        if it == tar_seq[0]:
            if i + len(tar_seq) <= len(input_seq) and input_seq[i:i + len(tar_seq)] == tar_seq:
                if i + len(tar_seq) + len(flw_seq) > len(input_seq):
                    return False
                if input_seq[i + len(tar_seq):i + len(tar_seq) + len(flw_seq)] != flw_seq:
                    return False
    return True


def led_by(input_seq: Tuple[str], tar_seq: Tuple[str], ld_seq: Tuple[str]) -> bool:
    for i, it in enumerate(input_seq):
        if it == tar_seq[0]:
            if i + len(tar_seq) <= len(input_seq) and input_seq[i:i + len(tar_seq)] == tar_seq:
                if i - len(ld_seq) < 0:
                    return False
                if i - len(ld_seq) >= 0 and input_seq[i - len(ld_seq):i] != ld_seq:
                    return False

    return True


def begin(input_seq: Tuple[str], tar_seq: Tuple[str]):
    return len(input_seq) >= len(tar_seq) and input_seq[: len(tar_seq)] == tar_seq


def end(input_seq: Tuple[str], tar_seq: Tuple[str]):
    return len(input_seq) >= len(tar_seq) and input_seq[-len(tar_seq):] == tar_seq

